/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.runtime.dialog;

import filenet.vw.api.VWException;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.runtime.VWTrkParticipant;
import filenet.vw.toolkit.runtime.VWTrkStepOccurrence;
import filenet.vw.toolkit.runtime.dialog.VWLockWork;
import filenet.vw.toolkit.runtime.dialog.VWLockWorkDialog;
import filenet.vw.toolkit.runtime.images.VWImageLoader;
import filenet.vw.toolkit.runtime.resources.VWResource;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWModalDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public final class VWLockStepDialog
extends VWModalDialog
implements ItemListener {
    private ImageIcon m_warningIcon = VWImageLoader.createImageIcon("warning.gif");
    private JCheckBox m_dontAskMeAgain = new JCheckBox();
    private static boolean m_bDontAskAgain = false;
    private boolean m_bCanceled = true;
    private boolean m_bStepLocked = false;
    private VWTrkStepOccurrence m_stepOccurrence = null;
    private VWTrkParticipant m_participant = null;
    private JTextArea m_warningTextArea = null;
    private JLabel m_stepLabel = null;
    private JLabel m_stepNameUI = null;
    private String m_stepName = null;
    private JLabel m_continueCmd = null;
    private JLabel m_cancelCmd = null;
    private JButton m_lockStepButton = null;
    private ActionListener m_lockStepButtonActionListener = null;
    private JButton m_cancelButton = null;
    private ActionListener m_cancelButtonActionListener = null;
    private JButton m_helpButton = null;
    private ActionListener m_helpButtonActionListener = null;

    public VWLockStepDialog(Frame parent, VWTrkStepOccurrence stepOccurrence) throws VWException {
        super(parent);
        this.initData(stepOccurrence);
        this.setupLayout();
    }

    public VWLockStepDialog(Frame parent, VWTrkParticipant participant) throws VWException {
        super(parent);
        this.initData(participant);
        this.setupLayout();
    }

    public static void setDontAskAgain(boolean flag) {
        m_bDontAskAgain = false;
    }

    private void initData(VWTrkStepOccurrence stepOccurrence) throws VWException {
        if (stepOccurrence == null) {
            throw new VWException("vw.toolkit.runtime.nullStepForLocking", "No step selected for locking");
        }
        this.m_stepOccurrence = stepOccurrence;
        int lockStatus = 0;
        if (this.m_stepOccurrence != null) {
            lockStatus = this.m_stepOccurrence.getLockedStatus();
        }
        this.shouldInvokeDialog(lockStatus);
        this.m_stepName = this.m_stepOccurrence.getStep().getStepName();
        if (this.m_stepName == null) {
            this.m_stepName = "";
        }
    }

    private void initData(VWTrkParticipant participant) throws VWException {
        int lockStatus = 0;
        if (participant == null) {
            throw new VWException("vw.toolkit.runtime.nullStepForLocking", "No step selected for locking");
        }
        this.m_participant = participant;
        lockStatus = this.m_participant.getLockedStatus();
        this.shouldInvokeDialog(lockStatus);
        this.m_stepName = participant.getStep().getStepName();
        if (this.m_stepName == null) {
            this.m_stepName = "";
        }
    }

    private void shouldInvokeDialog(int lockStatus) throws VWException {
        if (lockStatus == 0) {
            throw new VWException("vw.toolkit.runtime.s_inactiveStep", "The step selected to lock is not active");
        }
        if (lockStatus == 2) {
            throw new VWException("vw.toolkit.runtime.s_stepsAlreadyLocked", "The selected step is already locked by the current user");
        }
        if (m_bDontAskAgain) {
            this.lockSelectedStep();
        }
    }

    private void setupLayout() {
        this.m_bStepLocked = false;
        try {
            JPanel stepNamePanel = new JPanel();
            JPanel iconPanel = new JPanel();
            JPanel centerPanel = new JPanel();
            JPanel bottomPanel = new JPanel();
            JPanel checkBoxPanel = new JPanel();
            JPanel actionCmdPanel = new JPanel();
            JPanel mainPanel = new JPanel();
            Container container = this.getContentPane();
            JLabel label = null;
            int margin = 20;
            this.setResizable(false);
            container.setLayout(new BorderLayout());
            Dimension dim = VWStringUtils.stringToDimension(VWResource.s_lockStepDialogDim);
            if (dim == null) {
                dim = new Dimension(450, 340);
            }
            this.setSize(dim.width, dim.height);
            this.setVisible(false);
            this.setTitle(VWResource.s_lockStepDialogTitle);
            iconPanel.setLayout(new BorderLayout());
            label = new JLabel(this.m_warningIcon);
            label.setText("   ");
            iconPanel.add((Component)label, "First");
            iconPanel.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 0));
            centerPanel.setLayout(new GridBagLayout());
            stepNamePanel = new JPanel();
            stepNamePanel.setLayout(new BoxLayout(stepNamePanel, 2));
            this.m_stepLabel = new JLabel(VWResource.s_label.toString(VWResource.s_step));
            stepNamePanel.add(this.m_stepLabel);
            this.m_stepNameUI = new JLabel(this.m_stepName);
            stepNamePanel.add(this.m_stepNameUI);
            centerPanel.setLayout(new BoxLayout(centerPanel, 3));
            this.m_warningTextArea = new JTextArea(VWResource.s_stepLockWarning){

                public boolean getScrollableTracksViewportHeight() {
                    return true;
                }

                public boolean getScrollableTracksViewportWidth() {
                    return true;
                }
            };
            this.m_warningTextArea.setEditable(false);
            this.m_warningTextArea.setLineWrap(true);
            this.m_warningTextArea.setWrapStyleWord(true);
            this.m_warningTextArea.setOpaque(false);
            centerPanel.add(this.m_warningTextArea);
            checkBoxPanel.setBorder(BorderFactory.createEtchedBorder());
            this.m_dontAskMeAgain.setText(VWResource.s_dontAskMeAgain.toString());
            this.m_dontAskMeAgain.setSelected(m_bDontAskAgain);
            this.m_dontAskMeAgain.addItemListener(this);
            JTextArea dontAskMeAgainDescrip = new JTextArea(VWResource.s_dontAskMeAgainDescrip);
            dontAskMeAgainDescrip.setMargin(new Insets(2, 6, 2, 6));
            dontAskMeAgainDescrip.setEditable(false);
            dontAskMeAgainDescrip.setLineWrap(true);
            dontAskMeAgainDescrip.setWrapStyleWord(true);
            dontAskMeAgainDescrip.setOpaque(false);
            checkBoxPanel.setLayout(new BorderLayout());
            checkBoxPanel.add((Component)this.m_dontAskMeAgain, "First");
            checkBoxPanel.add((Component)dontAskMeAgainDescrip, "Center");
            centerPanel.add(checkBoxPanel);
            actionCmdPanel.setLayout(new BoxLayout(actionCmdPanel, 3));
            actionCmdPanel.add(Box.createVerticalStrut(10));
            this.m_continueCmd = new JLabel(VWResource.s_lockStepContinue.toString(VWResource.s_lockStep));
            actionCmdPanel.add(this.m_continueCmd);
            this.m_cancelCmd = new JLabel(VWResource.s_lockStepCancel.toString(VWResource.s_cancel));
            actionCmdPanel.add(this.m_cancelCmd);
            actionCmdPanel.add(Box.createVerticalStrut(10));
            mainPanel.setLayout(new BorderLayout());
            mainPanel.add((Component)stepNamePanel, "First");
            mainPanel.add((Component)centerPanel, "Center");
            mainPanel.add((Component)actionCmdPanel, "Last");
            this.m_lockStepButton = new JButton(VWResource.s_lockStep);
            this.m_lockStepButtonActionListener = new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    VWLockStepDialog.this.lockSelectedStep();
                    VWLockStepDialog.this.m_bCanceled = false;
                    VWLockStepDialog.this.setVisible(false);
                }
            };
            this.m_lockStepButton.addActionListener(this.m_lockStepButtonActionListener);
            this.m_cancelButton = new JButton(VWResource.s_cancel);
            this.m_cancelButtonActionListener = new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    VWLockStepDialog.this.m_bCanceled = true;
                    VWLockStepDialog.this.setVisible(false);
                }
            };
            this.m_cancelButton.addActionListener(this.m_cancelButtonActionListener);
            this.m_helpButton = new JButton(VWResource.s_help);
            this.m_helpButtonActionListener = new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    VWHelp.displayPage(VWHelp.Help_Process_Tracker + "bpfpt037.htm");
                }
            };
            this.m_helpButton.addActionListener(this.m_helpButtonActionListener);
            bottomPanel.setLayout(new FlowLayout(2));
            bottomPanel.add(this.m_lockStepButton);
            bottomPanel.add(this.m_cancelButton);
            bottomPanel.add(this.m_helpButton);
            bottomPanel.add(Box.createHorizontalStrut(margin));
            container.add(Box.createVerticalStrut(margin), "First");
            container.add((Component)iconPanel, "Before");
            container.add((Component)mainPanel, "Center");
            container.add(Box.createHorizontalStrut(margin), "After");
            container.add((Component)bottomPanel, "Last");
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void addNotify() {
        super.addNotify();
        Font boldFont = null;
        Font font = null;
        font = this.getFont();
        if (font != null) {
            boldFont = new Font(font.getName(), 1, font.getSize());
        }
        if (boldFont != null) {
            this.m_stepLabel.setFont(boldFont);
            this.m_stepNameUI.setFont(boldFont);
            this.m_dontAskMeAgain.setFont(boldFont);
            this.m_continueCmd.setFont(boldFont);
            this.m_cancelCmd.setFont(boldFont);
        }
    }

    public void itemStateChanged(ItemEvent e) {
        int state = e.getStateChange();
        if (state == 2) {
            m_bDontAskAgain = false;
        } else if (state == 1) {
            m_bDontAskAgain = true;
        }
    }

    protected void lockSelectedStep() {
        block4: {
            VWLockWork lockWork = null;
            try {
                if (this.m_stepOccurrence != null) {
                    lockWork = new VWLockWork((Dialog)this, this.m_stepOccurrence);
                    break block4;
                }
                if (this.m_participant != null) {
                    lockWork = new VWLockWork((Dialog)this, this.m_participant);
                    break block4;
                }
                return;
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                JOptionPane.showMessageDialog(this, ex.getLocalizedMessage(), VWResource.s_unlock, 1, null);
            }
        }
    }

    public boolean isCanceled() {
        return this.m_bCanceled;
    }

    public boolean isStepLocked() {
        return this.m_bStepLocked;
    }

    public boolean isAskAgain() {
        return !m_bDontAskAgain;
    }

    private void invokeLockWorkDialog(Frame parent) {
        try {
            VWLockWorkDialog dlg = null;
            if (this.m_stepOccurrence != null) {
                dlg = new VWLockWorkDialog(parent, this.m_stepOccurrence);
            } else if (this.m_participant != null) {
                dlg = new VWLockWorkDialog(parent, this.m_participant);
            }
            if (dlg != null) {
                dlg.setVisible(true);
                dlg.removeReferences();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void removeReferences() {
        super.removeReferences();
        this.m_warningIcon = null;
        if (this.m_dontAskMeAgain != null) {
            this.m_dontAskMeAgain.removeItemListener(this);
            this.m_dontAskMeAgain = null;
        }
        this.m_stepOccurrence = null;
        this.m_participant = null;
        this.m_warningTextArea = null;
        this.m_stepLabel = null;
        this.m_stepNameUI = null;
        this.m_stepName = null;
        this.m_continueCmd = null;
        this.m_cancelCmd = null;
        if (this.m_lockStepButton != null) {
            this.m_lockStepButton.removeActionListener(this.m_lockStepButtonActionListener);
            this.m_lockStepButtonActionListener = null;
            this.m_lockStepButton = null;
        }
        if (this.m_helpButton != null) {
            this.m_helpButton.removeActionListener(this.m_helpButtonActionListener);
            this.m_helpButtonActionListener = null;
            this.m_helpButton = null;
        }
        if (this.m_cancelButton != null) {
            this.m_cancelButton.removeActionListener(this.m_cancelButtonActionListener);
            this.m_cancelButtonActionListener = null;
            this.m_cancelButton = null;
        }
        this.removeAll();
    }
}

